#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

struct karte {
    int N;
    vector<int> P, pos, bad;
    ll cost;

    karte(int n): N(n), P(n+1), pos(n+1), bad(n+1), cost(0) {}

    void init() {
        for(int i = 1; i <= N; i++) pos[P[i]] = i;
        for(int x = 1; x < N; x++) {
            bad[x] = (pos[x] > pos[x+1]);
            cost += bad[x];
        }
    }

    void karteupd(int x) {
        if (x < 1 || x >= N) return;
        cost -= bad[x];
        bad[x] = (pos[x] > pos[x+1]);
        cost += bad[x];
    }

    ll pswap(int i, int j) {
        int a = P[i], b = P[j];

        for (int x : {a - 1, a, b - 1, b})
            karteupd(x);

        swap(P[i], P[j]);
        swap(pos[a], pos[b]);

        for (int x : {a - 1, a, b - 1, b})
            karteupd(x);

        return cost;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    karte Karte(N);

    for(int i = 1; i <= N; i++) cin >> Karte.P[i];
    Karte.init();

    cout << Karte.cost << '\n';
    while (Q--) {
        int i, j;
        cin >> i >> j;
        cout << Karte.pswap(i, j) << '\n';
    }

    return 0;
}